<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Media;
use App\Models\WatchList;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    /**
     * Show the application dashboard.
     */
    public function index()
    {
        // Gather Real Stats
        $stats = [
            'users' => User::count(),
            'media' => Media::count(),
            'anime' => Media::where('type', 'anime')->count(),
            'movies' => Media::where('type', 'movie')->count(),
            'tv' => Media::where('type', 'tv')->count(),
            'recent_users' => User::latest()->take(5)->get(),
        ];

        // System Health Check (Basic)
        $system = [
            'php' => PHP_VERSION,
            'db_driver' => DB::connection()->getDriverName(),
            'server' => $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown',
        ];

        return view('admin.dashboard', compact('stats', 'system'));
    }
}
