<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Media extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',
        'title',
        'description',
        'poster_path',
        'is_dub',
        'metadata',
    ];

    protected $casts = [
        'is_dub' => 'boolean',
        'metadata' => 'array',
    ];

    /**
     * Get the watchlists that include this media.
     */
    public function watchlists()
    {
        return $this->belongsToMany(User::class, 'watch_lists')->withPivot('status', 'progress', 'rating')->withTimestamps();
    }
}
