<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WatchList extends Model
{
    use HasFactory;

    protected $table = 'watch_lists';

    protected $fillable = [
        'user_id',
        'media_id',
        'status', // e.g., watching, completed, plan_to_watch
        'progress', // Episode number or timestamp
        'rating',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function media()
    {
        return $this->belongsTo(Media::class);
    }
}
