@extends('layouts.app')

@section('title', 'Database Configuration')

@section('content')
    <div>
        <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">Database Setup</h2>
        <p class="mt-2 text-center text-sm text-gray-600">
            Enter your database connection details.
        </p>
    </div>

    <form class="mt-8 space-y-6" action="{{ route('install.step2.post') }}" method="POST">
        @csrf
        <div class="rounded-md shadow-sm -space-y-px">
            <div>
                <label for="db_host" class="sr-only">DB Host</label>
                <input id="db_host" name="db_host" type="text" required class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 rounded-t-md focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 focus:z-10 sm:text-sm" placeholder="Database Host" value="{{ old('db_host', 'localhost') }}">
            </div>
            <div>
                <label for="db_port" class="sr-only">DB Port</label>
                <input id="db_port" name="db_port" type="text" required class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 focus:z-10 sm:text-sm" placeholder="Database Port" value="{{ old('db_port', '3306') }}">
            </div>
            <div>
                <label for="db_database" class="sr-only">Database Name</label>
                <input id="db_database" name="db_database" type="text" required class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 focus:z-10 sm:text-sm" placeholder="Database Name" value="{{ old('db_database', 'ensoxlzv_EnsoWatchList') }}">
            </div>
            <div>
                <label for="db_username" class="sr-only">Username</label>
                <input id="db_username" name="db_username" type="text" required class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 focus:z-10 sm:text-sm" placeholder="Database User" value="{{ old('db_username', 'ensoxlzv_admin') }}">
            </div>
            <div>
                <label for="db_password" class="sr-only">Password</label>
                <input id="db_password" name="db_password" type="password" class="appearance-none rounded-none relative block w-full px-3 py-2 border border-gray-300 placeholder-gray-500 text-gray-900 rounded-b-md focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 focus:z-10 sm:text-sm" placeholder="Database Password" value="{{ old('db_password', 'Mysecurep@ssw0rd') }}">
            </div>
        </div>

        <div>
            <button type="submit" class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Test Connection & Save
            </button>
        </div>
    </form>
@endsection
