@extends('layouts.user')

@section('title', 'Welcome')

@section('content')
<div class="relative min-h-[500px] flex items-center justify-center bg-gray-900 border-b border-gray-800">
    <!-- Grid Highlight (Cosmetic) -->
    <div class="absolute inset-0 bg-cover bg-center opacity-20" style="background-image: url('https://image.tmdb.org/t/p/original/uDgy6hyPd82kOHh6I95FLtLnj6p.jpg'); filter: blur(2px);"></div>
    <div class="absolute inset-0 bg-gradient-to-t from-gray-900 via-gray-900/40 to-transparent"></div>

    <div class="relative z-10 text-center px-4 max-w-4xl mx-auto">
        <h1 class="text-5xl md:text-7xl font-extrabold tracking-tight text-white mb-6 drop-shadow-lg">
            Track Everything. <br>
            <span class="text-transparent bg-clip-text bg-gradient-to-r from-indigo-400 to-cyan-400">Never Forget.</span>
        </h1>
        <p class="mt-4 text-xl text-gray-300 max-w-2xl mx-auto mb-10">
            The ultimate self-hosted platform for tracking your Anime, TV Shows, and Movies. 
            Syncs with TMDB, Simkl, and more.
        </p>
        
        <div class="flex flex-col sm:flex-row justify-center gap-4">
             @auth
                <a href="{{ route('home') }}" class="px-8 py-4 bg-indigo-600 hover:bg-indigo-700 text-white rounded-xl font-bold text-lg shadow-lg hover:shadow-indigo-500/30 transition transform hover:-translate-y-1">
                    Go to WatchList
                </a>
            @else
                <a href="{{ route('register') }}" class="px-8 py-4 bg-indigo-600 hover:bg-indigo-700 text-white rounded-xl font-bold text-lg shadow-lg hover:shadow-indigo-500/30 transition transform hover:-translate-y-1">
                    Get Started Free
                </a>
                <a href="{{ route('login') }}" class="px-8 py-4 bg-gray-800 hover:bg-gray-700 text-gray-200 border border-gray-700 rounded-xl font-bold text-lg transition">
                    Sign In
                </a>
            @endauth
        </div>
    </div>
</div>

<!-- Features Section -->
<div class="py-20 bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl font-bold text-white mb-4">Why EnsoWatchList?</h2>
            <p class="text-gray-400">Everything you need to manage your media consumption.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 text-center">
            <div class="p-6 bg-gray-800 rounded-2xl border border-gray-700">
                <div class="bg-indigo-900/50 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4 text-indigo-400">
                    <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 3-2 3 2zm0 0v-8"></path></svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-2">Anime & Dub Tracking</h3>
                <p class="text-gray-400">Specific support for tracking Subs vs Dubs, so you never lose your place.</p>
            </div>
             <div class="p-6 bg-gray-800 rounded-2xl border border-gray-700">
                <div class="bg-pink-900/50 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4 text-pink-400">
                    <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 4v16M17 4v16M3 8h4m10 0h4M3 12h18M3 16h4m10 0h4M4 20h16a1 1 0 001-1V5a1 1 0 00-1-1H4a1 1 0 00-1 1v14a1 1 0 001 1z"></path></svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-2">Rich Metadata</h3>
                <p class="text-gray-400">Automatically pulls posters, summaries, and ratings from TMDB and TVDB.</p>
            </div>
             <div class="p-6 bg-gray-800 rounded-2xl border border-gray-700">
                <div class="bg-green-900/50 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4 text-green-400">
                    <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-2">Privacy First</h3>
                <p class="text-gray-400">Self-hosted on your own cPanel. Your data belongs to you, not a corporation.</p>
            </div>
        </div>
    </div>
</div>
@endsection
