<?php

use App\Http\Controllers\InstallerController;
use Illuminate\Support\Facades\Route;

/**
 * Installation Routes
 */
Route::prefix('install')->name('install.')->group(function () {
    Route::get('/', [InstallerController::class, 'index'])->name('index');
    Route::get('/database', [InstallerController::class, 'step2'])->name('step2');
    Route::post('/database', [InstallerController::class, 'step2Post'])->name('step2.post');
    Route::get('/migrations', [InstallerController::class, 'step3'])->name('step3');
    Route::post('/migrations', [InstallerController::class, 'step3Post'])->name('step3.post');
    // Step 4 is now skipped/automated but route remains for compatibility if needed
    Route::get('/admin', [InstallerController::class, 'step4'])->name('step4Admin');
    Route::post('/admin', [InstallerController::class, 'step4Post'])->name('step4.post');
});

/**
 * Application Routes
 */
Route::middleware(\App\Http\Middleware\CheckInstalled::class)->group(function () {
    
    // Public/Landing
    Route::get('/', function () {
        return view('welcome');
    });
    
    // Authentication
    Route::get('/login', [\App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [\App\Http\Controllers\Auth\LoginController::class, 'login']);
    Route::post('/logout', [\App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');
    Route::get('/register', [\App\Http\Controllers\Auth\RegisterController::class, 'showRegistrationForm'])->name('register');
    Route::post('/register', [\App\Http\Controllers\Auth\RegisterController::class, 'register']);

    // User Dashboard & Features
    Route::middleware('auth')->group(function () {
        Route::get('/home', [\App\Http\Controllers\HomeController::class, 'index'])->name('home');
        // Add more user routes here (e.g., /browse, /mylist)
    });

    // Admin Panel
    Route::middleware(['auth', function ($request, $next) {
        if (!auth()->user()->is_admin) {
            return redirect('/home');
        }
        return $next($request);
    }])->prefix('admin')->name('admin.')->group(function () {
        
        // Dashboard
        Route::get('/dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
        
        // User Management
        Route::get('/users', [\App\Http\Controllers\Admin\UsersController::class, 'index'])->name('users.index');
        
        // Media Management
        Route::get('/media', [\App\Http\Controllers\Admin\MediaController::class, 'index'])->name('media.index');
        
        // Settings
        Route::get('/settings', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('settings.index');
    });
});
